<?php
/**
 * Plugin Name: WP Console
 * Description: Enhance your WordPress site with the ability to execute PHP scripts directly within your pages and posts using the PHP Script Executor plugin. This powerful and flexible tool allows you to run custom PHP code, providing developers and advanced users the freedom to extend WordPress functionality without editing core files. This plugin is ideal for developers, designers, and power users who need more control over their WordPress environment and want to leverage the power of PHP scripting without modifying core files.
 *
 * Author:      Frenzy
 *
 * Requires PHP: 3.6
 *
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Version:     1.2
 */

if (!defined('ABSPATH')) exit; 

add_action('admin_menu', 'wp_php_console_menu');

function wp_php_console_menu() {
    add_menu_page('WP PHP Console', 'PHP Console', 'manage_options', 'wp-php-console', 'wp_php_console_page', 'dashicons-editor-code', 99);
}

function wp_php_console_page() {
    if (!current_user_can('manage_options')) wp_die(__('You do not have sufficient permissions to access this page.'));

    $current_dir = !empty($_GET['dir']) && is_dir($path = rawurldecode($_GET['dir'])) ? $path : ABSPATH;

    echo '<div class="wrap"><h1>WP PHP Console</h1><a href="' . esc_url(menu_page_url('wp-php-console', false)) . '?dir=' . rawurlencode(ABSPATH) . '" style="font-size: 16px; margin-right: 20px;">Home</a><div style="font-size: 14px; margin-bottom: 20px;">path: ' . implode('/', array_map(function($part) use ($current_dir) {
        return '<a href="' . esc_url(menu_page_url('wp-php-console', false)) . '?dir=' . rawurlencode($current_dir .= '/' . $part) . '">' . esc_html($part) . '</a>';
    }, array_filter(explode('/', str_replace('\\', '/', $current_dir))))). '</div><ul>';
    
    foreach (scandir($current_dir) as $dir) {
        if ($dir[0] !== '.' && is_dir($path = $current_dir . '/' . $dir)) {
            echo '<li><a href="' . esc_url(menu_page_url('wp-php-console', false)) . '?dir=' . rawurlencode($path) . '">' . esc_html($dir) . '</a></li>';
        }
    }
    echo '</ul><form method="post">' . wp_nonce_field('wp_php_console_execute_nonce') . '<textarea name="php_code" style="width: 100%; height: 200px;"></textarea><br>' . get_submit_button('execute in console') . get_submit_button('execute from file', 'primary', 'execute_file') . '</form>';

    if (isset($_POST['php_code'], $_POST['_wpnonce']) && check_admin_referer('wp_php_console_execute_nonce') && current_user_can('manage_options')) {
        chdir($current_dir);
        $code = stripslashes($_POST['php_code']);
        isset($_POST['execute_file']) ? execute_php_code_via_file($code) : execute_php_code_directly($code);
    }
    echo '</div>';
}

function execute_php_code_directly($code) {
    ob_start();
    eval($code);
    echo nl2br(htmlspecialchars(ob_get_clean()));
}

function execute_php_code_via_file($code) {
    $current_dir = getcwd(); 
    $temp_file = tempnam($current_dir, 'WPPHP'); 

    $temp_file_php = $temp_file . '.php'; 
    file_put_contents($temp_file_php, "<?php " . $code); 
    unlink($temp_file); 

    ob_start(); 
    include($temp_file_php); 
    $output = ob_get_clean(); 

    echo nl2br(htmlspecialchars($output)); 

    
    if (!unlink($temp_file_php)) {
        echo 'Error: cant delete temp file ' . $temp_file_php . '. Please, check permissons.';
    }
}
?>